"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ElementPropertiesBase_1 = require("./ElementPropertiesBase");
var ArrayProperty = /** @class */ (function (_super) {
    __extends(ArrayProperty, _super);
    function ArrayProperty() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ArrayProperty.prototype.GetFieldTemplate = function () {
        return rnJQuery("<div class=\"col-sm-12\" style=\"vertical-align: top;text-align: left;background-color: #fafafa;border: 1px solid #f0f0f0;\">\n                            <table style=\"width: 98%\">\n                                <tr>\n                                    <td style=\"border-style: none;\">\n                                        <label class=\"checkbox control-group rednao-properties-control-label\" style=\"display: block;vertical-align: top; text-align: left;margin:0;\">\n                                            " + this.PropertyTitle + "\n                                        </label>\n                                    </td>\n                                 </tr>\n                                 <tr>\n                                    <td class=\"fieldContainer\" style=\"text-align: left;border-style: none;\">\n                                   \n                                    </td>\n                                 </tr>\n                            </table>\n                          </div>");
    };
    ArrayProperty.prototype.InternalGenerateHtml = function ($fieldContainer) {
        var _this = this;
        var currentValues = this.GetPropertyCurrentValue();
        $fieldContainer.append(this.GetItemList(currentValues));
        $fieldContainer.find('table.listOfItems').append("<tr><td style='border-bottom-style: none;'><button class='redNaoPropertyClearButton' value='None'>Clear</button></td></tr>");
        $fieldContainer.find('.redNaoPropertyClearButton').click(function (event) {
            event.preventDefault();
            $fieldContainer.find('.itemSel').removeAttr('checked');
            _this.UpdateProperty();
        });
        $fieldContainer.find('.cloneArrayItem').click(function (e) {
            _this.CloneItem(rnJQuery(e.currentTarget));
        });
        $fieldContainer.find('.deleteArrayItem').click(function (e) {
            _this.DeleteItem(rnJQuery(e.currentTarget));
        });
        $fieldContainer.find('input[type=text],input[type=radio],input[type=checkbox]').change(function () {
            _this.UpdateProperty();
        });
        $fieldContainer.find('input[type=text]').keyup(function () {
            _this.UpdateProperty();
        });
        this.ItemsList = $fieldContainer.find('.listOfItems');
    };
    ;
    ArrayProperty.prototype.GetItemList = function (items) {
        var allowImages = typeof this.AdditionalInformation.AllowImages != 'undefined' && this.AdditionalInformation.AllowImages == true;
        var list = '<table style="width: 100%;margin-left: 10px;" class="listOfItems"><tr><th style="text-align: center">Sel</th><th>Label</th>' + (allowImages ? '<th>Image Url</th>' : '') + '<th>Amount</th></tr>';
        var isFirst = true;
        for (var i = 0; i < items.length; i++) {
            list += this.CreateListRow(isFirst, items[i]);
            isFirst = false;
        }
        return list;
    };
    ;
    ArrayProperty.prototype.DeleteItem = function (jQueryElement) {
        var array = this.GetPropertyCurrentValue();
        var index = jQueryElement.parent().parent().index();
        array.splice(index, 1);
        jQueryElement.parent().parent().remove();
        this.UpdateProperty();
    };
    ;
    ArrayProperty.prototype.CloneItem = function (jQueryElement) {
        var jQueryToClone = jQueryElement.parent().parent();
        var data = this.GetRowData(jQueryToClone);
        if (this.AdditionalInformation.SelectorType == 'radio')
            data.sel = 'n';
        var jQueryNewRow = rnJQuery(this.CreateListRow(false, data));
        jQueryToClone.after(jQueryNewRow);
        var self = this;
        jQueryNewRow.find('.cloneArrayItem').click(function () {
            self.CloneItem(rnJQuery(this));
        });
        jQueryNewRow.find('.deleteArrayItem').click(function () {
            self.DeleteItem(rnJQuery(this));
        });
        jQueryNewRow.find('input[type=text],input[type=radio],input[type=checkbox]').change(function () {
            self.UpdateProperty();
        });
        this.UpdateProperty();
    };
    ;
    ArrayProperty.prototype.CreateListRow = function (isFirst, item) {
        var allowImages = typeof this.AdditionalInformation.AllowImages != 'undefined' && this.AdditionalInformation.AllowImages == true;
        if (allowImages && typeof item.url == 'undefined')
            item.url = '';
        var row = '<tr class="redNaoRowOption">' +
            '       <td style="border-style: none; text-align: center;">' + this.GetSelector(item) + '</td>' +
            '       <td style="border-style: none;width: ' + (allowImages ? "50%" : "100%") + ';"><input style="width: 100%" type="text" class="itemText" value="' + RedNaoEscapeHtml(item.label) + '"/></td>' +
            (allowImages ? '<td style="border-style: none;width:50%;"><input type="text" class="itemUrl" style="text-align: left; width: 100%;" value="' + RedNaoEscapeHtml(item.url) + '"/></td>' : '') +
            '       <td style="border-style: none;"><input type="text" class="itemValue" style="text-align: left; width: 50px;" value="' + RedNaoEscapeHtml(item.value) + '"/></td>' +
            '       <td style="border-style: none; text-align: center;vertical-align: middle;"><img style="cursor: pointer; width:15px;height:15px;" class="cloneArrayItem" src="' + smartFormsRootPath + 'images/clone.png" title="Clone"></td>';
        if (!isFirst)
            row += ' <td style="border-style: none !important;text-align: center;vertical-align: middle;"><img style="cursor: pointer;width:15px;height:15px;" class="deleteArrayItem" src="' + smartFormsRootPath + 'images/delete.png" title="Delete"></td>';
        row += '</tr>';
        return row;
    };
    ;
    ArrayProperty.prototype.GetSelector = function (item) {
        var selected = '';
        if (RedNaoGetValueOrEmpty(item.sel) == 'y')
            selected = 'checked="checked"';
        if (this.AdditionalInformation.SelectorType == 'radio')
            return '<input class="itemSel" type="radio" ' + selected + ' name="propertySelector"/>';
        else
            return '<input class="itemSel" type="checkbox" ' + selected + '/>';
    };
    ;
    ArrayProperty.prototype.UpdateProperty = function () {
        var processedValueArray = [];
        var self = this;
        var rows = this.ItemsList.find('tr.redNaoRowOption').each(function () {
            var jQueryRow = rnJQuery(this);
            var row = self.GetRowData(jQueryRow);
            processedValueArray.push(row);
        });
        this.Manipulator.SetValue(this.PropertiesObject, this.PropertyName, processedValueArray, this.AdditionalInformation);
        this.RefreshElement();
    };
    ;
    ArrayProperty.prototype.GetRowData = function (jQueryRow) {
        var objectToReturn = {
            label: jQueryRow.find('.itemText').val(),
            value: jQueryRow.find('.itemValue').val(),
            sel: (jQueryRow.find('.itemSel').is(':checked') ? 'y' : 'n'),
            url: ''
        };
        if (typeof this.AdditionalInformation.AllowImages != 'undefined' && this.AdditionalInformation.AllowImages == true)
            objectToReturn.url = jQueryRow.find('.itemUrl').val();
        return objectToReturn;
    };
    return ArrayProperty;
}(ElementPropertiesBase_1.ElementPropertiesBase));
exports.ArrayProperty = ArrayProperty;
//# sourceMappingURL=ArrayProperty.js.map